#ifndef __mygame_h__
	#define __mygame_h__

#include <gxframework/gxframework.h>
#include "shaderprogram.h"

class MyGame : public Gx::Game
{
public:
	MyGame();

	void initialize();
	void release();

	void reshape(const Gx::Viewport& viewport);
	void input(float elapsedTime);
	void update(float elapsedTime);
	void render(float elapsedTime);

protected:
	void initBuffers();
	void initVertexPositionBuffer();

private:
	static const unsigned int buffersCount = 1;

	GLuint			m_buffers[buffersCount];
	GLuint			m_vertexPositionBuffer;
	GLuint			m_positionLocation;

	ShaderProgram	m_identityProgram;

	
};

#endif // ~__mygame_h__
